/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.loader;

import dev.felnull.imp.client.music.loader.IMusicLoader;
import dev.felnull.imp.client.music.loader.LavaPlayerMusicLoader;
import dev.felnull.imp.client.music.loader.YoutubeDownloaderMusicLoader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;

public class IMPMusicLoaders {
    protected static final Map<ResourceLocation, IMusicLoader> LOADERS = new LinkedHashMap<ResourceLocation, IMusicLoader>();
    public static final ResourceLocation LAVA_YOUTUBE = new ResourceLocation("iammusicplayer", "lava_youtube");
    public static final ResourceLocation YOUTUBE_DOWNLOADER = new ResourceLocation("iammusicplayer", "youtube_downloader");
    public static final ResourceLocation LAVA_SOUNDCLOUD = new ResourceLocation("iammusicplayer", "lava_soundcloud");
    public static final ResourceLocation LAVA_HTTP = new ResourceLocation("iammusicplayer", "lava_http");

    public static void init() {
        IMPMusicLoaders.registerLoader(YOUTUBE_DOWNLOADER, new YoutubeDownloaderMusicLoader());
        IMPMusicLoaders.registerLoader(LAVA_YOUTUBE, new LavaPlayerMusicLoader("youtube"));
        IMPMusicLoaders.registerLoader(LAVA_SOUNDCLOUD, new LavaPlayerMusicLoader("soundcloud"));
        IMPMusicLoaders.registerLoader(LAVA_HTTP, new LavaPlayerMusicLoader("http"));
    }

    public static void registerLoader(ResourceLocation location, IMusicLoader loader) {
        LOADERS.put(location, loader);
    }

    public static IMusicLoader getLoader(ResourceLocation location) {
        return LOADERS.get(location);
    }

    public static List<IMusicLoader> getLoaders() {
        return new ArrayList<IMusicLoader>(LOADERS.values());
    }
}

